#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
	nl = []   # ispravno formatirane linije

	A = list(map(int, lines[0].strip().split()))
	assert len(A) == 8, "len != 8 kriv"
	for x in A:
		assert 1 <= x <= 100, "ai kriv"
	nl.append(("{}" + " {}"*7 + "\n").format(*A))
	
	jed = 1
	for x in A:
		if x != A[0]: jed = 0
	
	alt = 1
	for i in range(2, len(A)):
		if A[i] != A[i - 2]: alt = 0

	assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
	assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
	return jed, alt

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'jednaki': 3, 'alternira' : 3, 'normalni' : 4}

def what_cluster(data):
	jed, alt = data
	if jed: return 'jednaki'
	if alt: return 'alternira'
	return 'normalni'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
	# mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

	files.sort()
	B = []
	for f in files:
		if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
			B[-1].append(f)
		else:
			B.append([f])
	return B


if __name__ == "__main__":
	f = []
	for pattern in sys.argv[1:]:
		for filename in glob.glob(pattern):
			f.append(filename)

	bc = []
	for batch in group_in_batches(f):
		if 'dummy' not in batch[0]:
			bc.append([])
			for filename in batch:
				print("{}: ".format(filename), end="")
				try:
					lines = open(filename).readlines()
					summary = check(lines)
					c = what_cluster(summary)
					if 'dummy' not in batch[0]:
						bc[-1].append(c)
				except Exception as e:
					print("Greska!", e)
					raise
				else:
					print("Sve ok! (cluster {}, summary = {})".format(c, summary))
	clusters = {}
	for b in bc:
		for c in b:
			assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
		if not b[0] in clusters:
			clusters[b[0]] = 0
		clusters[b[0]] += 1

	assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

	# Buda test - provjeri duplikate
	hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
	assert len(hashes) == len(f), "Ima duplikata!"
